﻿//////////////////////////////////////////////
// ProfilableClass.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "ProfilingHelper.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	enum class PROFILABLE_DATA
	{
		PROFILING_DATA_TIME = 0,
		PROFILING_DATA_STATISTICS
	} ;

	class DLL_GRAPHICS_EXPORT ProfilableClass
	{			
		public :
		
			// Constructor, destructor
			ProfilableClass (System* system) noexcept ;
			virtual ~ProfilableClass () ;

			// Getters
			const ProfilingInfoHolder& getLastProfiledData () const ;

			// Setters
			void setHasToProfile (bool value, std::function<void (const ProfilingInfoHolder&)> toCall) ;
			void setDataToProfile (bool value, PROFILABLE_DATA toTrack) ;

			// Checkpoints
			void prepareProfiling () ;
			void endProfiling () ;

		private :
		
			// Attributes
			nkMemory::UniquePtr<ProfilingHelper> _helper ;
			bool _hasToProfile ;
	} ;
}